program mess1
!This program computes the MESS estimates


!It requires 

! REQUIRED INPUT CONSISTS OF THE 6 ELEMENT ASCII
!	FILE MCPARMS.ASC. THIS FILE CONTAINS N,
!	THE number of observations, MOLD THE MAXIMUM
!	NUMBER OF NEIGHBORS, M THE NUMBER OF NEIGHBORS 
!	ACTUALLY USED, L AN UNUSED INTEGER,
!	ITER AN UNUSED INTEGER, and kols, the number
!   of columns of the data matrix (with intercept). THE Variables
!	L AND ITER are not used in this program, so any arbitrary positive integer will work.

!	ALSO REQUIRED IS THE M ELEMENT VECTOR OF WEIGHTS
!	IN THE ASCII FILE WVEC WITH THE FIRST WEIGHT 
!	APPLYING TO THE NEAREST NEIGHBOR, ETC.

!	THE PROGRAM REQUIRES THE N BY MOLD
!	MATRIX NNMAT FOUND IN NNMAT.ASC 

! It requires the n element vector ydata.asc. This is the dependent variable

! It requires the n by kols matrix xdata.asc. These are the independent variables.
! The first column should include the intercept of 1s (or all y,x should have 0 mean)
! Note, this is in row-order. That is the data should have have as the first row the first observation, second row the second observation, etc
! Hence, each row should begin with a 1 and have kols records. Note, this does not follow the Fortran convention of column order. However, 
! row order is more common for statistical applications.


!Kelley Pace, 7/31/00

use numerical_libraries

implicit none


real difsecs
real(8) mcparmvec(6)
INTEGER	BEGTIME(8), ENDTIME(8), DT(8),q
integer n,kols,mold,i,j,m,irank
integer,allocatable::nnmat(:,:),hank(:,:)
logical,allocatable::hank_mask(:,:)
double complex,allocatable::polyroot(:)
real(8),allocatable::xols(:,:),y(:),ymat(:,:),wy(:)
real(8),allocatable::xycov(:,:),bmat(:,:),rchol(:,:)
real(8),allocatable::xymean(:),ytemp(:),wvec(:)
real(8),allocatable::scpe(:,:),rrr(:,:),zzz(:,:),p(:),dp(:)
real(8),allocatable::xymat(:,:)


OPEN(UNIT=666,FILE='MCPARMS.ASC')
READ(666,*) MCPARMVEC
CLOSE(666)

N=idnint(MCPARMVEC(1) )
MOLD=idnint(MCPARMVEC(2))
M=idnint(MCPARMVEC(3))
kols=idnint(mcparmvec(6))

q=7


allocate(y(n),xols(n,kols),nnmat(n,mold),ymat(n,q),wy(n) )
allocate(xymat(n,(kols+q))	 )
allocate(xycov((kols+q),(kols+q)) )
allocate(xymean((kols+q)))
allocate(ytemp(n) )
allocate(wvec(m))
allocate(rrr(q,q))
allocate(zzz(q,q))
allocate(rchol(kols,kols))
allocate(bmat(kols,q))
allocate(scpe(q,q))
allocate(hank(q,q))
allocate(hank_mask(q,q))
allocate(p(2*q-1))
allocate(dp(2*q-2))
allocate(polyroot(2*q-3))


!reads dependent variable n by 1
open(unit=666,file='ydata.asc')
read(666,*)	y
close(666)

!reads independent variables in row order (including column of 1s for intercept)  n by kols
open(unit=666,file='xdata.asc')
do i=1,n

read(666,*) (xols(i,j),j=1,kols)

end do
CLOSE(666)



!reads n by m matrix of neighbors
open(unit=666,file='nnmat.asc')
do i=1,n
read(666,*) (nnmat(i,j),j=1,mold)
end do																										  
close(666)


!reads m by 1 vector of weights, wvec(1) is the weight of the nearest neighbor, etc
open(unit=666,file='wvec.asc')
read(666,*) wvec
CLOSE(666)

!echoing of data, functions of data	


print *, '############# ECHOING OF DATA AND FUNCTIONS OF DATA (AVERAGES, ETC) ###########'
print *,' '
print *,'n(#ofobs),kols(#ofvars),mold(total possible# neighbors),m(actual# neighbors)'
print *, n,kols,mold,m
print *,' '
print *,'Average of ydata.asc',sum(y)/n
print *,' '
print *,'Average of xdata.asc'
print *,sum(xols,1)/n
print *,' '
print *,'1st,nth row of nnmat.asc'
print *,nnmat(1,:)
print *,' '
print *,nnmat(n,:)
print *,' '
PRINT *,'WVEC (weights by 1st, 2nd,... mth neighbor) is '
PRINT *,WVEC
PRINT *,' '
print *, 'The elements of WVEC should sum to 1 ',sum(wvec)
print *,' '
print *,'############### END OF ECHOING #################################### '
print *,' '
print *,'%%%%%%%%%%%%%%%%%%%%%%% MESS ESTIMATION %%%%%%%%%%%%%%%%%%%%%%%%% '
print *, ' '


CALL DATE_AND_TIME(VALUES=BEGTIME)


!computes spatially lagged ymat. 

ymat(:,1)=y
wy=y
do i=2,q
ytemp=0.0
DO J=1,m
yTEMP=yTEMP+WVEC(J)*wy(NNMAT(:,J))
END DO
wy=ytemp
ymat(:,i)=wy
end do


!placing x,y side-by-side
xymat(:,1:kols)=xols
xymat(:,(kols+1):(kols+q))=ymat
xymean=sum(xymat,1)/n

!subtracts mean from x,y for better numerical conditioning
do j=2,(kols+q)
xymat(:,j)=xymat(:,j)-xymean(j)
end do

!redo this to use in the IMSL routine drcov
xymean=sum(xymat,1)/n

!crossproducts of xy matrix
xycov=matmul(transpose(xymat),xymat)


!IMSL subroutine for computing betas and sum-of-squared errors (scpe)
CALL dRCOV (0, kols, q, xyCOV, (kols+q), xymean, dble(n),&
dble(0.0000001),Bmat, kols, Rchol, kols, IRANK, SCPE, q)

!weighting matrix for matrix exponential
rrr=0.0
do i=1,q
rrr(i,i)=1.0/fac(i-1)
end do


!weighted sse
zzz=matmul(matmul(rrr,scpe),rrr)


!hankel constant antidiagonal matrix
do i=1,q
do j=1,q
hank(i,j)=i+j
end do
end do


!use hankel matrix to create mask for traces on antidiagonals
!this creates a polynomial
do i=2,(2*q)
hank_mask=(hank==i)
p(i-1)=sum(pack(zzz,hank_mask))
end do


!first derivative of the polynomial
do i=1,(2*q-2)
dp(i)=p(i+1)*(i)
end do


!zeros of the polynomial
call dzplrc((2*q-3),dp,polyroot)


CALL DATE_AND_TIME(VALUES=ENDTIME)
DT=(ENDTIME-BEGTIME)
DIFSECS=DT(3)*(24.0*3600.0)+DT(5)*3600.0+DT(6)*60.0+DT(7)+DT(8)/1000.0



call dwrrrn('bmat',kols,q,bmat,kols,0)
call dwrrrn('scpe',q,q,scpe,q,0)
call dwrrrn('rrr',q,q,rrr,q,0)
call wrirn('hank',q,q,hank,q,0)
call dwrrrn('zzz',q,q,zzz,q,0)
call dwrrrn('p',(2*q-1),1,p,(2*q-1),0)
call dwrrrn('dp',(2*q-2),1,dp,(2*q-2),0)
print *,' '
call dwrcrn('candidate roots',(2*q-3),1,polyroot,(2*q-3),0)
print *,' '
print *,' '
print *,'Time taken in seconds ',difsecs
print *,' '
print *,' '
print *,'&&&&&&&&&&&&&&&&&&&&&& PROGRAM FINISHED &&&&&&&&&&&&&&&&&&&&&&&&&&&&&& '

end

